"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.messageInRaw = exports.Message = void 0;
const expungeAllContentsOut_1 = require("../models/expungeAllContentsOut");
const listResponseMessageOut_1 = require("../models/listResponseMessageOut");
const messageOut_1 = require("../models/messageOut");
const messagePoller_1 = require("./messagePoller");
const request_1 = require("../request");
const messageIn_1 = require("../models/messageIn");
class Message {
    constructor(requestCtx) {
        this.requestCtx = requestCtx;
    }
    get poller() {
        return new messagePoller_1.MessagePoller(this.requestCtx);
    }
    list(appId, options) {
        const request = new request_1.SvixRequest(request_1.HttpMethod.GET, "/api/v1/app/{app_id}/msg");
        request.setPathParam("app_id", appId);
        request.setQueryParams({
            limit: options === null || options === void 0 ? void 0 : options.limit,
            iterator: options === null || options === void 0 ? void 0 : options.iterator,
            channel: options === null || options === void 0 ? void 0 : options.channel,
            before: options === null || options === void 0 ? void 0 : options.before,
            after: options === null || options === void 0 ? void 0 : options.after,
            with_content: options === null || options === void 0 ? void 0 : options.withContent,
            tag: options === null || options === void 0 ? void 0 : options.tag,
            event_types: options === null || options === void 0 ? void 0 : options.eventTypes,
        });
        return request.send(this.requestCtx, listResponseMessageOut_1.ListResponseMessageOutSerializer._fromJsonObject);
    }
    create(appId, messageIn, options) {
        const request = new request_1.SvixRequest(request_1.HttpMethod.POST, "/api/v1/app/{app_id}/msg");
        request.setPathParam("app_id", appId);
        request.setQueryParams({
            with_content: options === null || options === void 0 ? void 0 : options.withContent,
        });
        request.setHeaderParam("idempotency-key", options === null || options === void 0 ? void 0 : options.idempotencyKey);
        request.setBody(messageIn_1.MessageInSerializer._toJsonObject(messageIn));
        return request.send(this.requestCtx, messageOut_1.MessageOutSerializer._fromJsonObject);
    }
    expungeAllContents(appId, options) {
        const request = new request_1.SvixRequest(request_1.HttpMethod.POST, "/api/v1/app/{app_id}/msg/expunge-all-contents");
        request.setPathParam("app_id", appId);
        request.setHeaderParam("idempotency-key", options === null || options === void 0 ? void 0 : options.idempotencyKey);
        return request.send(this.requestCtx, expungeAllContentsOut_1.ExpungeAllContentsOutSerializer._fromJsonObject);
    }
    get(appId, msgId, options) {
        const request = new request_1.SvixRequest(request_1.HttpMethod.GET, "/api/v1/app/{app_id}/msg/{msg_id}");
        request.setPathParam("app_id", appId);
        request.setPathParam("msg_id", msgId);
        request.setQueryParams({
            with_content: options === null || options === void 0 ? void 0 : options.withContent,
        });
        return request.send(this.requestCtx, messageOut_1.MessageOutSerializer._fromJsonObject);
    }
    expungeContent(appId, msgId) {
        const request = new request_1.SvixRequest(request_1.HttpMethod.DELETE, "/api/v1/app/{app_id}/msg/{msg_id}/content");
        request.setPathParam("app_id", appId);
        request.setPathParam("msg_id", msgId);
        return request.sendNoResponseBody(this.requestCtx);
    }
}
exports.Message = Message;
function messageInRaw(eventType, payload, contentType) {
    const headers = contentType ? { "content-type": contentType } : undefined;
    return {
        eventType,
        payload: {},
        transformationsParams: {
            rawPayload: payload,
            headers,
        },
    };
}
exports.messageInRaw = messageInRaw;
//# sourceMappingURL=message.js.map